﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.IO

Class DirectoryTreeView
    Inherits TreeView

    ' 这是 Class 构造函数。
    Public Sub New()
        ' 为长目录名称稍微多留一些空间。
        Me.Width *= 2

        ' 获取树的图像。
        Me.ImageList = New ImageList()
        With Me.ImageList.Images
            .Add(My.Resources.FLOPPY)
            .Add(My.Resources.CLSDFOLD)
            .Add(My.Resources.OPENFOLD)
        End With

        ' 构造树。
        RefreshTree()
    End Sub

    ' 处理子类 TreeView 的 BeforeExpand 事件。请参见 /DirectoryScanner/DirectoryScanner.vb 
    '  中有关 Before_____ 和 After_______ TreeView
    ' 事件对的详细注释。
    Protected Overrides Sub OnBeforeExpand(ByVal tvcea As TreeViewCancelEventArgs)
        MyBase.OnBeforeExpand(tvcea)

        ' 出于性能方面的考虑，并避免 TreeView 在大型节点更新期间“闪烁”，
        ' 最好将更新代码包装在 BeginUpdate...
        ' EndUpdate 语句中。
        Me.BeginUpdate()

        Dim tn As TreeNode
        ' 为用户单击的节点中的每个子节点添加子节点。
        ' 出于性能方面的考虑，DirectoryTreeView 中的每个节点
        ' 只有包含下一级子节点时才显示 + 号
        ' 以指示用户是否可以展开该节点。因此当用户展开某一
        ' 节点以便为下一级的子节点显示相应的 + 号时，
        ' 必须添加 *它们的* 子节点。
        For Each tn In tvcea.Node.Nodes
            AddDirectories(tn)
        Next tn

        Me.EndUpdate()
    End Sub

    ' 此子例程用于为父节点下的每个目录添加
    '子节点，该父节点作为参数传递。请参见
    ' OnBeforeExpand 事件处理程序中的详细注释。
    Sub AddDirectories(ByVal tn As TreeNode)
        tn.Nodes.Clear()

        Dim strPath As String = tn.FullPath
        Dim diDirectory As New DirectoryInfo(strPath)
        Dim adiDirectories() As DirectoryInfo

        Try
            ' 获取作为 DirectoryInfo 对象的所有子目录的数组。
            adiDirectories = diDirectory.GetDirectories()
        Catch exp As Exception
            Exit Sub
        End Try

        Dim di As DirectoryInfo
        For Each di In adiDirectories
            ' 为每个子目录创建子节点，方法是传入
            ' 该目录名称和其节点将使用的图像。
            Dim tnDir As New TreeNode(di.Name, 1, 2)
            ' 将新子节点添加到父节点。
            tn.Nodes.Add(tnDir)

            ' 现在可以通过递归调用
            ' AddDirectories() 来填充整个树：
            '
            '   AddDirectories(tnDir)
            '
            ' 这种方法太慢，不过可以试一下！
        Next
    End Sub

    ' 此子例程清除现有 TreeNode 对象并重新生成
    ' 显示逻辑驱动器的 DirectoryTreeView。
    Public Sub RefreshTree()

        ' 出于性能方面的考虑，并避免 TreeView 在大型节点更新期间“闪烁”，
        ' 最好将更新代码包装在 BeginUpdate...
        ' EndUpdate 语句中。
        BeginUpdate()

        Nodes.Clear()

        ' 使磁盘驱动器成为根节点。
        Dim astrDrives As String() = Directory.GetLogicalDrives()

        Dim strDrive As String
        For Each strDrive In astrDrives
            Dim tnDrive As New TreeNode(strDrive, 0, 0)
            Nodes.Add(tnDrive)
            AddDirectories(tnDrive)

            ' 将 C 驱动器设置为默认选择的驱动器。
            If strDrive = "C:\" Then
                Me.SelectedNode = tnDrive
            End If
        Next

        EndUpdate()
    End Sub
End Class
